% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dejaData.R
\name{MakeDejaData}
\alias{MakeDejaData}
\title{Create a \code{DejaData} object}
\usage{
MakeDejaData(data, arm, Id, rate = NULL)
}
\arguments{
\item{data}{A data frame containing the subject}

\item{arm, }{character the column name of the treatment arm for each subject}

\item{Id, }{character the column name of subject Id}

\item{rate, }{character the column name of the rate to be used when simulating (or NULL,
if using DejaData to import a data set, see \code{\link{ImportSim}})}
}
\value{
A \code{DejaData} object
}
\description{
This object is can be used to create a \code{SingleSim} object with
subject specific rates
}
\examples{

set.seed(232)

my.df <- data.frame(Id=1:100,
                    arm=c(rep(0,50),rep(1,50)),
                    covar=rbinom(n=100,size=1,prob=0.5))

my.df$rate <- 0.0025 + my.df$covar*0.002 + (1-my.df$arm)*0.002

my.dejaData <- MakeDejaData(my.df,arm="arm",rate="rate",Id="Id")

}
