% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{add_blur}
\alias{add_blur}
\title{De-identification via categorical aggregation}
\usage{
add_blur(object, ..., blur = c())
}
\arguments{
\item{object}{Either a \code{data.frame}, \code{tibble}, or existing \code{DeidentList} pipeline.}

\item{...}{variables to be transformed.}

\item{blur}{a key-value pair such that 'key' is replaced by 'value' on
transformation.}
}
\value{
A 'DeidentList' representing the untrained transformation pipeline.
The object contains fields:
\itemize{
\item \code{deident_methods} a list of each step in the pipeline (consisting of \code{variables} and \code{method})
}

and methods:
\itemize{
\item \code{mutate} apply the pipeline to a new data set
\item \code{to_yaml} serialize the pipeline to a '.yml' file
}
}
\description{
\code{add_blur()} adds an bluring step to a transformation pipeline
(NB: intended for categorical data).  When ran as a transformation, values
are recoded to a lower cardinality as defined by \code{blur}.
#'
}
\examples{
.blur <- category_blur(ShiftsWorked$Shift, `Working` = "Day|Night")
pipe.blur <- add_blur(ShiftsWorked, `Shift`, blur = .blur)
pipe.blur$mutate(ShiftsWorked)
 
}
\seealso{
\code{\link[=category_blur]{category_blur()}} is provided to aid in defining the \code{blur}
}
\keyword{API}
