% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffler.R
\name{Shuffler}
\alias{Shuffler}
\title{Shuffler class for applying 'shuffling' transform}
\arguments{
\item{method}{[optional] A function representing the method of re-sampling
to be used.  By default uses exhaustive sampling without replacement.}

\item{keys}{Value(s) to be transformed.}

\item{...}{Value(s) to concatenate to \code{keys} and transform
@inheritParams Pseudonymizer}

\item{limit}{integer - the minimum number of observations a variable needs to
have for shuffling to be performed.  If the variable has length less than \code{limit}
values are replaced with \code{NA}s.}
}
\description{
Create new Shuffler object

Update minimum vector size for shuffling

Apply the deidentifcation method to the supplied \code{keys}

Convert \code{self} to a list.
}
\details{
'Shuffling' refers to the a random sampling of a variable without
replacement e.g. [A, B, C] becoming [B, A, C] but not [A, A, B].
Shuffling will preserve top level metrics (e.g. mean, median, mode) but
removes ordinal properties i.e. correlations and auto-correlations
}
\section{Fields}{

\describe{
\item{\code{limit}}{minimum vector length to be shuffled.  If vector to be
transformed has length < limit, the data is replaced with NAs}
}}

