% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensembles.R
\name{ensemble.deeptrafo}
\alias{ensemble.deeptrafo}
\title{Deep ensembling for neural network transformation models}
\usage{
\method{ensemble}{deeptrafo}(
  x,
  n_ensemble = 5,
  reinitialize = TRUE,
  mylapply = lapply,
  verbose = FALSE,
  patience = 20,
  plot = TRUE,
  print_members = TRUE,
  stop_if_nan = TRUE,
  save_weights = TRUE,
  callbacks = list(),
  save_fun = NULL,
  seed = seq_len(n_ensemble),
  ...
)
}
\arguments{
\item{x}{Object of class \code{"deeptrafo"}.}

\item{n_ensemble}{Numeric; number of ensemble members to fit.}

\item{reinitialize}{Logical; if \code{TRUE} (default), model weights are
initialized randomly prior to fitting each member. Fixed weights are
not affected.}

\item{mylapply}{Function; \code{lapply} function to be used; defaults to
\code{lapply}}

\item{verbose}{Logical; whether to print training in each fold.}

\item{patience}{Integer; number of patience for early stopping.}

\item{plot}{Logical; whether to plot the resulting losses in each fold.}

\item{print_members}{Logical; print results for each member.}

\item{stop_if_nan}{Logical; whether to stop ensembling if \code{NaN} values
occur}

\item{save_weights}{Logical; whether to save the ensemble weights.}

\item{callbacks}{List; callbacks used for fitting.}

\item{save_fun}{Function; function to be applied to each member to be stored
in the final result.}

\item{seed}{Numeric vector of length \code{n_ensemble}; seeds for model
initialization.}

\item{...}{Further arguments passed to \code{object$fit_fun}.}
}
\value{
Ensemble of \code{"deeptrafo"} models with list of training histories
    and fitted weights included in \code{ensemble_results}. For details see
    the return statment in \code{\link[deepregression]{ensemble}}.
}
\description{
Deep ensembling for neural network transformation models
}
