% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patterns.R
\name{geo_pattern}
\alias{geo_pattern}
\alias{geo_grob}
\title{Get a FGDC geologic plotting pattern}
\usage{
geo_pattern(
  code,
  scale = 2,
  col = NULL,
  fill = NULL,
  alpha = NULL,
  bg = "white"
)

geo_grob(code, col = NULL, fill = NULL, alpha = NULL, bg = "white")
}
\arguments{
\item{code}{The number corresponding to the pattern to return. Strings and
numbers are permitted.}

\item{scale}{The visual scale of the pattern (higher values mean the pattern
is more zoomed in).}

\item{col}{The color to use for the lines of the pattern.}

\item{fill}{The color used to fill various closed shapes (e.g., circles) in
the pattern.}

\item{alpha}{The transparency to use for the fill of the pattern.}

\item{bg}{The background color to use for the pattern.}
}
\value{
\code{geo_grob()} returns a \link[grid:gTree]{grob} object with a single
instance of the desired pattern. \code{geo_pattern()} returns a
\link[grid:patterns]{GridPattern} object with a repeated instance of the
desired pattern.
}
\description{
Retrieve a single geologic pattern as defined in the \href{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd.php}{FGDC Digital Cartographic Standard for Geologic Map Symbolization} by the \href{https://www.usgs.gov/}{U.S. Geological Survey} and the \href{https://ngmdb.usgs.gov/fgdc_gds/index.php}{Geologic Data Subcommittee (GDS)} of the \href{https://www.fgdc.gov/}{Federal Geographic Data Committee (FGDC)}.
}
\details{
For specific codes, see the "pattern numbers" in the \href{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd/fgdc-geolsym-patternchart.pdf}{full pattern chart}
for valid \code{code} values. Daven Quinn has also assembled more accessible
documentation of the \href{https://davenquinn.com/projects/geologic-patterns/#pattern-reference}{map patterns/codes}
and \href{https://davenquinn.com/projects/geologic-patterns/#series-600}{lithology patterns/codes}.
The set of patterns with names is also included in the built-in dataset
\link{fgdc_names} (and a label dictionary is available using \code{\link[=fgdc_dict]{fgdc_dict()}}.
\code{\link[rmacrostrat:def_lithologies]{rmacrostrat::def_lithologies()}} can also be used to look up pattern codes
for various lithologies (see the "fill" column). Note that codes associated
with color variants (e.g., "101-M") are supported but will result in the
default color variant instead (usually black and white, e.g., "101-K").

These patterns were originally processed and optimized by Daven Quinn and
are hosted on \href{https://github.com/davenquinn/geologic-patterns/}{GitHub}.
}
\examples{
library(grid)
# Get a generic igneous pattern
pattern1 <- geo_pattern(code = "313-K")
# Get the pattern for a sandstone
pattern2 <- geo_pattern(code = "607")

# plot the two patterns
grid.newpage()
grid.draw(rectGrob(gp = gpar(fill = pattern1)))
grid.newpage()
grid.draw(rectGrob(gp = gpar(fill = pattern2)))
}
\seealso{
FGDC patterns:
\code{\link{fgdc_dict}()},
\code{\link{fgdc_names}},
\code{\link{grid.pattern_geo}()},
\code{\link{scale_fill_geopattern}()}
}
\concept{patterns}
