% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dir_mult_GD.R
\name{dir_mult_GD}
\alias{dir_mult_GD}
\title{Dirichlet-Multinomial mixture model by Gradient Descend algorithm}
\usage{
dir_mult_GD(
  x,
  k,
  n_it = 100,
  eps = 1e-05,
  seed_choice = 1,
  KK = 20,
  min_iter = 2,
  init = NULL
)
}
\arguments{
\item{x}{Document-term matrix describing the frequency of terms that occur in a collection of documents. Rows correspond to documents in the collection and columns correspond to terms.}

\item{k}{Number of clusters/groups.}

\item{n_it}{Number of Gradient Descend steps.}

\item{eps}{Tolerance level for the convergence of the algorithm. Default is \code{1e-05}.}

\item{seed_choice}{Set seed for reproducible results.}

\item{KK}{Maximum number of iterations allowed for the \link[stats]{nlminb} function (see below).}

\item{min_iter}{Minimum number of Gradient Descend steps.}

\item{init}{Vector containing the initial document allocations for the initialization of the algorithm. If \proglang{NULL} (default) initialization is carried out via spherical k-means (\link[skmeans]{skmeans}).}
}
\value{
A list containing the following elements:
\item{x}{The data matrix.}
\item{clusters}{the clustering labels.}
\item{k}{the number of clusters.}
\item{numobs}{the sample size.}
\item{p}{the vocabulary size.}
\item{likelihood}{vector containing the likelihood values at each iteration.}
\item{pi_hat}{estimated probabilities of belonging to the \code{k} clusters.}
\item{Theta}{matrix containing the estimates of the Theta parameters for each cluster.}
\item{f_z_x}{matrix containing the posterior probabilities of belonging to each cluster.}
\item{AIC}{Akaike Information Criterion (AIC) value of the fitted model.}
\item{BIC}{Bayesian Information Criterion (BIC) value of the fitted model.}
}
\description{
Performs parameter estimation by means of a Gradient Descend algorithm and cluster allocation
for the Dirichlet-Multinomial mixture model.
}
\details{
Starting from the data given by \code{x} the Dirichlet-Multinomial mixture model is fitted
and \code{k} clusters are obtained.
The algorithm for the parameter estimation is the Gradiend Descend.
In particular, the function assigns initial values to weights of the Dirichlet-Multinomial distribution for each cluster
and inital weights for the elements of the mixture. The estimates are obtained with maximum \code{n_it} steps of the
Descent Algorithm algorithm or until a tolerance level \code{eps} is reached; by using the posterior distribution
of the latent variable z, the documents are allocated to the cluster which maximizes the
posterior distribution.
For further details see the references.
}
\examples{
# Load the CNAE2 dataset
data("CNAE2")

# Perform parameter estimation and clustering, very
# few iterations are used for this example
dir_CNAE2 = dir_mult_GD(x = CNAE2, k = 2, n_it = 2)

# Shows cluster labels to documents
dir_CNAE2$clusters

}
\references{
Anderlucci L, Viroli C (2020). "Mixtures of Dirichlet-Multinomial distributions for supervised and unsupervised classification of short text data." \emph{Advances in Data Analysis and Classification}, \bold{14}, 759-770. \doi{10.1007/s11634-020-00399-3}.
}
