% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_estimation.R
\name{simulate_estimation}
\alias{simulate_estimation}
\title{Simulate Estimation}
\usage{
simulate_estimation(
  lambda1,
  lambda2,
  term1,
  term2,
  num_simulations,
  num_iterations
)
}
\arguments{
\item{lambda1}{Eigenvalues of the first segment.}

\item{lambda2}{Eigenvalues of the second segment.}

\item{term1}{The negative drift term of the left hand side of the random walk.}

\item{term2}{The negative drift term of the right hand side of the random walk.}

\item{num_simulations}{Specifies the number of simulations to be conducted during the estimation process.
It is recommended to set num_simulations to a large value to ensure greater certainty and reliability of the results.
A higher number of simulations helps in capturing the variability and improves the accuracy of the estimation.}

\item{num_iterations}{Determines the size of the two-sided random walk in the estimation process (each path).
If the jump size of the change point is small, num_iterations should be set to higher values to achieve accurate results.
For jump size >= 1, the default value is 100.}
}
\value{
A numeric vector of the estimation results centered around zero.
The spike of the histogram is represents estimated change point, and it is expected to be at zero.
}
\description{
The estimation of the detected change point.
}
\examples{
# Example usage
lambda1 <- rnorm(10)
lambda2 <- rnorm(10)
term1 <- -1
term2 <- -2
result <- simulate_estimation(lambda1, lambda2, term1, term2, 
                               num_iterations = 100, num_simulations = 100)
}
