% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_change_point.R
\name{mle_change_point_detection}
\alias{mle_change_point_detection}
\title{MLE Change Point Detection}
\usage{
mle_change_point_detection(input_data, verbose = TRUE)
}
\arguments{
\item{input_data}{A numeric matrix of observations for multivariate time series
data where the dimension is not greater than the observations. Date columns should not be inputted.}

\item{verbose}{Logical value indicating whether to print messages during the function execution. Default is TRUE.}
}
\value{
An object of class 'mle_change_point_result' containing the index of the change point estimate, its MLE value, and the MLE data.
}
\description{
Maximum likelihood estimation change point detection.
}
\examples{
# Example usage
data <- matrix(rnorm(1000), ncol = 10)
tau_range <- 30:(nrow(data) - 30)
result <- mle_change_point_detection(data)
print(result)
}
