#' @importFrom VMDecomp vmd
#' @importFrom forecast nnetar forecast
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'


vmdTDNN <- function(data, stepahead=10, nIMF=4, alpha=2000, tau=0, D=FALSE)
{
  data <- ts(data)
  data<- as.vector(data)
  v<- vmd(data , alpha=2000, tau=0, K=nIMF, DC=D, init=1, tol = 1e-6)
  AllIMF<-v$u
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data) - stepahead) + 1):length(data)),
  ]
  Fcast_AllIMF <- NULL
  for (AllIMF in 1:(ncol(IMF_trn))) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[, AllIMF]
    vmdTDNNFit <- forecast::nnetar(as.ts(IndIMF))
    vmdTDNN_fcast = forecast::forecast(vmdTDNNFit, h = stepahead)
    vmdTDNN_fcast_Mean = vmdTDNN_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(vmdTDNN_fcast_Mean))
  }
  FinalvmdTDNN_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_vmdTDNN = mean(abs(data_test - FinalvmdTDNN_fcast))
  MAPE_vmdTDNN = mean(abs(data_test - FinalvmdTDNN_fcast)/data_test)
  RMSE_vmdTDNN = sqrt(mean((data_test - FinalvmdTDNN_fcast)^2))
  return(list(AllIMF = AllIMF, data_test = data_test,
              AllIMF_forecast = Fcast_AllIMF, FinalvmdTDNN_forecast = FinalvmdTDNN_fcast,
              MAE_vmdTDNN = MAE_vmdTDNN, MAPE_vmdTDNN = MAPE_vmdTDNN,
              RMSE_vmdTDNN = RMSE_vmdTDNN ))
}
