#' @importFrom Rlibeemd emd_num_imfs ceemdan
#' @importFrom nnfor elm
#' @importFrom forecast forecast
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'

ceemdanELM <- function(data, stepahead=10, num.IMFs=emd_num_imfs(length(data)),
                       s.num=4L, num.sift=50L, ensem.size=250L, noise.st=0.2){
  n.IMF <- num.IMFs
  AllIMF <- ceemdan(ts(data), num_imfs = n.IMF, ensemble_size = ensem.size, noise_strength = noise.st,
                    S_number = s.num, num_siftings = num.sift, rng_seed = 0L, threads = 0L)
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data)-stepahead)+1):length(data)),]
  Fcast_AllIMF <- NULL
  for (IMF in 1:ncol(IMF_trn)) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[ ,IMF]
    ceemdanELMFit <- nnfor::elm(as.ts(IndIMF), keep = NULL, difforder = NULL, outplot = c(
      FALSE), sel.lag = c(FALSE), direct = c(FALSE),
      allow.det.season = c(FALSE))
    ceemdanELM_fcast=forecast::forecast(ceemdanELMFit, h=stepahead)
    ceemdanELM_fcast_Mean=ceemdanELM_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(ceemdanELM_fcast_Mean))
  }
  FinalceemdanELM_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_ceemdanELM=mean(abs(data_test - FinalceemdanELM_fcast))
  MAPE_ceemdanELM=mean(abs(data_test - FinalceemdanELM_fcast)/data_test)
  rmse_ceemdanELM=sqrt(mean((data_test - FinalceemdanELM_fcast)^2))
  Plot_IMFs <- AllIMF
  AllIMF_plots <- plot(Plot_IMFs)
  return(list(TotalIMF = n.IMF, data_test=data_test, AllIMF_forecast=Fcast_AllIMF,
              FinalceemdanELM_forecast=FinalceemdanELM_fcast, MAE_ceemdanELM=MAE_ceemdanELM,
              MAPE_ceemdanELM=MAPE_ceemdanELM, rmse_ceemdanELM=rmse_ceemdanELM,
              AllIMF_plots=AllIMF_plots))
}
