% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_layer}
\alias{add_layer}
\title{Add any kind of layer to the deckgl widget}
\usage{
add_layer(
  deckgl,
  class_name,
  data = NULL,
  properties = list(),
  ...,
  id = "hopeful-hopper",
  tooltip = NULL,
  source = NULL,
  filter = NULL
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{class_name}{The name of the JavaScript layer class, e. g. \code{ScatterplotLayer}.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}

\item{tooltip}{A tooltip template that defines what should be displayed when the mouse enters an object.
You can also pass a list with the properties \code{html} and \code{style}. See also \code{\link{use_tooltip}}.}

\item{source}{The ID of the data source. See \code{\link{add_source}}.}

\item{filter}{A filter expression that is applied to the data object.}
}
\value{
A deckgl widget object.
}
\description{
Generic function to add any kind of layer to the deckgl widget.
Usually you will not use this one but any of the \code{add_*_layer} functions instead.
}
