% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_bitmap-layer.R
\name{add_bitmap_layer}
\alias{add_bitmap_layer}
\title{Add a bitmap layer to the deckgl widget}
\usage{
add_bitmap_layer(
  deckgl,
  image = NULL,
  properties = list(),
  ...,
  id = "h3-hexagon-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{image}{image}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
Add a bitmap layer to the deckgl widget
}
\examples{
image <- paste0(
  "https://raw.githubusercontent.com/",
  "uber-common/deck.gl-data/master/",
  "website/sf-districts.png"
)
bounds <- c(-122.5190, 37.7045, -122.355, 37.829)

deck <- deckgl() \%>\%
  add_bitmap_layer(image = image, bounds = bounds) \%>\%
  add_basemap()

if (interactive()) deck
}
