% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dfl_decompose}
\alias{plot.dfl_decompose}
\title{Plot decomposition terms for quantiles}
\usage{
\method{plot}{dfl_decompose}(
  x,
  ...,
  confidence_bands = TRUE,
  confidence_level = 0.95,
  uniform_bands = FALSE
)
}
\arguments{
\item{x}{an object of class "dfl_decompose", usually, a result of a call to [dfl_decompose()] with [statistics = "quantiles"].}

\item{...}{other parameters to be passed through to plot function.}

\item{confidence_bands}{If `TRUE` (default) and if standard errors have been bootstrapped, confidence bands are plotted.}

\item{confidence_level}{numeric value between 0 and 1 (default = 0.95) that defines the confidence interval
plotted as a ribbon and defined as \code{qnorm((1-confidence_level)/2)} * standard error.}

\item{uniform_bands}{If `FALSE` (default), pointwise confidence bands are computed. Otherwise, uniform bands are constructed
based on the bootstrapped Kolmogrov-Smirnov statistic (see \link{summary.dfl_decompose}).}
}
\value{
a ggplot illustrating the decomposition terms for quantiles.
}
\description{
The function plots decomposition terms for quantiles estimated
with \code{dfl_decompose} over the  unit interval.
}
\examples{
data("men8305")
flf_model <- log(wage) ~ union * (education + experience) + education * experience
flf_male_inequality <- dfl_decompose(flf_model,
  data = men8305,
  weights = weights,
  group = year
)
plot(flf_male_inequality)

}
