% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifier.R
\name{modifier}
\alias{modifier}
\title{Create or read a set of data modification rules}
\usage{
modifier(..., .file, .data)
}
\arguments{
\item{...}{A comma-separated list of modification rules.}

\item{.file}{(optional) A character vector of file locations.}

\item{.data}{(optional) A \code{data.frame} with at least a column \code{"rule"}
of type \code{character}. Optionally, the following columns of metadata
can be provided (all \code{character}, except \code{"created"} which 
should be \code{POSIXct}): \code{"name"}, 
\code{"label"}, \code{"description"}, \code{"origin"}, \code{"created"}.}
}
\value{
An object of class \code{modifier}.
}
\description{
Create or read a set of data modification rules
}
\examples{
m <- modifier( if (height < mean(height)) height <- 2*height
, if ( weight > mean(weight) ) weight <- weight/2  )
modify(women,m)


}
