% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_dci}
\alias{export_dci}
\title{Export DCI Results to Spatial Format}
\usage{
export_dci(net, results, type = "rivers", relative = FALSE, quiet = TRUE)
}
\arguments{
\item{net}{A \code{\link{river_net}} object.}

\item{results}{A \code{dci_results} object, or a list of such objects, as returned by
\code{\link[=calculate_dci]{calculate_dci()}}.}

\item{type}{A character string specifying which component of the river network
the results should be exported for. Valid options are \code{"rivers"} (default),
or \code{"bars"}.}

\item{relative}{A logical value indicating whether relative DCI values should
be returned in addition to raw values. Defaults to \code{FALSE}.}

\item{quiet}{Logical. If \code{FALSE}, prints the global DCI and a plot of river
segments to the console. Defaults to \code{TRUE}.}
}
\value{
An \code{sf} object containing the corresponding DCI results joined
to the selected network component. If multiple results are supplied, result
columns are appended by a number corresponding to the index of the
associated results.
}
\description{
Exports the output of \code{calculate_dci()} as a spatial object with DCI values joined
to the relevant features in the river network.
}
\examples{
res_pot <- calculate_dci(net = yamaska_net, form = "pot", pass = "pass_1",
quiet = TRUE)
res_dia <- calculate_dci(net = yamaska_net, form = "dia", pass = "pass_1",
quiet = TRUE)

# Export segment-level potamodromous DCI results to rivers
riv_results <- export_dci(net = yamaska_net, results = res_pot,
type = "rivers")

# Can also be run quietly to keep from plotting results
riv_results <- export_dci(net = yamaska_net, results = res_pot,
type = "rivers", quiet = TRUE)

# Results can also be exported to barrier points
bar_results <- export_dci(net = yamaska_net, results = res_pot,
type = "bars")

# If multiple results are calculated these can be combined together
all_res <- export_dci(net = yamaska_net, results = list(res_pot, res_dia),
type = "rivers")
}
