% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{moving_cov}
\alias{moving_cov}
\title{Moving Covariance model}
\usage{
moving_cov(r_t, V = 22)
}
\arguments{
\item{r_t}{List of daily returns}

\item{V}{Length of the rolling window adopted. By default, V is 22}
}
\value{
A list with the \eqn{H_t} matrix, for each \eqn{t}.
}
\description{
Obtains the matrix H_t, under the Moving Covariance model.
}
\examples{
\donttest{
require(xts)
# close to close daily log-returns
r_t_s<-diff(log(sp500['2010/2019'][,3]))
r_t_s[1]<-0
r_t_n<-diff(log(nasdaq['2010/2019'][,3]))
r_t_n[1]<-0
r_t_f<-diff(log(ftse100['2010/2019'][,3]))
r_t_f[1]<-0
db_m<-merge.xts(r_t_s,r_t_n,r_t_f)
db_m<-db_m[complete.cases(db_m),]
colnames(db_m)<-c("S&P500","NASDAQ","FTSE100")
# list of returns
r_t<-list(db_m[,1],db_m[,2],db_m[,3])
MC<-moving_cov(r_t,V=60)
}
}
