% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugbank_parser.R
\name{parseDrugBank}
\alias{parseDrugBank}
\title{parseDrugBank}
\usage{
parseDrugBank(
  db_path,
  drug_options = NULL,
  parse_salts = FALSE,
  parse_products = FALSE,
  references_options = NULL,
  cett_options = NULL
)
}
\arguments{
\item{db_path}{\strong{string}, full path for the \strong{DrugBank} xml or
zip file.}

\item{drug_options}{\strong{character vector}, list of sub drug related nodes
names options to parse (default = NULL). Check \code{drug_node_options()}
for all available options. If its value is `NULL` ONLY `drug_general_information`
will be placed in the returned dvobject.}

\item{parse_salts}{\strong{boolean}, parse salts info (default = FALSE)}

\item{parse_products}{\strong{boolean}, parse products info (default = FALSE)}

\item{references_options}{\strong{character vector}, list of sub references
related nodes names options to parse (default = NULL).
Check \code{references_node_options()} for all available options.}

\item{cett_options}{\strong{character vector}, list of sub cett related nodes
names options to parse (default = NULL). Check \code{cett_nodes_options()}
for all available options.}
}
\value{
dvobject
}
\description{
parses given DrugBank XML database into a dvobject. dvobject is a list of
 data.frames in which each data.frame represents a part of parsed data (i.e
 drugs, prices, carriers, ...)
}
\seealso{
Other parsers: 
\code{\link{cett_nodes_options}()},
\code{\link{drug_node_options}()},
\code{\link{references_node_options}()}
}
\concept{parsers}
