% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog.R
\name{dbi.catalog}
\alias{dbi.catalog}
\title{Create a \code{dbi.catalog}}
\usage{
dbi.catalog(conn, schemas)
}
\arguments{
\item{conn}{a connection handle returned by \code{\link[DBI]{dbConnect}} or a
zero-argument function that returns a connection handle.}

\item{schemas}{a character vector of distinct schema names. These schemas will be loaded
into the \code{dbi.catalog}. By default (when \code{schemas} is missing),
\code{dbi.catalog} loads all available schemas.}
}
\value{
a \code{dbi.catalog}.
}
\description{
A \code{dbi.catalog} represents a database catalog.
}
\examples{
# chinook.duckdb is a zero-argument function that returns a DBI handle
(db <- dbi.catalog(chinook.duckdb))

# list schemas
ls(db)

# list the tables in the schema 'main'
ls(db$main)

}
