% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_utils.R
\name{total_response}
\alias{total_response}
\title{Number of of responses at a given frequency}
\usage{
total_response(
  dt,
  col_name = NULL,
  by = c("month", "quarter", "week"),
  date_name = "ref_date"
)
}
\arguments{
\item{dt}{data table of responses}

\item{col_name}{name of column containing responses}

\item{by}{frequency of response aggregation, one of `"month"`, `"quarter"`, `"week"`}

\item{date_name}{name of column containing dates}
}
\value{
The number of responses at the frequency
}
\description{
Return the total number of responses to categorical answers at a specified frequency
}
\examples{
dt <- data.frame("ref_date" = seq.Date(as.Date("2000-01-01"), length.out = 100, by = "week"),
                 "response" = c(rep("yes", 20), rep("no",50),rep("yes",30)))
out <- total_response(dt, col_name = "response")
}
