% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{extend_ts}
\alias{extend_ts}
\title{Ajoute de nouvelles valeurs à un ts}
\usage{
extend_ts(
  series,
  replacement,
  date_ts_to = NULL,
  replace_na = TRUE,
  times = 1L,
  each = 1L
)
}
\arguments{
\item{series}{un objet ts unidimensionnel conforme aux règles de assert_ts}

\item{replacement}{un vecteur de même type que le ts \code{series}}

\item{date_ts_to}{un vecteur numérique, de préférence \code{integer}, au format
date_ts, c'est-à-dire \code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)}.}

\item{replace_na}{un booléen.}

\item{times}{un entier qui précise le nombre de fois où \code{replacement}
doit être répété, le vecteur entier.}

\item{each}{un entier qui précise le nombre de fois où \code{replacement}
doit être répété mais élément par élément.}
}
\value{
En sortie, la fonction retourne une copie de l'objet \code{series}
complété avec le vecteur \code{replacement}.
}
\description{
La fonction \code{extend_ts} ajoute de nouvelles valeurs à un ts.
}
\details{
\code{date_ts_to} désigne la date jusqu'à laquelle le remplacement
s'effectue. Par défault, cette valeur vaut \code{NULL}.

Si \code{replace_na} vaut \code{TRUE} alors le remplacement commence dès que
l'objet ne contient que des NA. Dans le cas contraire, le ts est étendu,
qu'il contienne des NA ou non à la fin.
Si le vecteur \code{replacement} est de taille un sous-multiple de la différence
de période entre la date de fin de \code{series} et \code{date_ts_to}, le vecteur
\code{replacement} est répété jusqu'à la date \code{date_ts_to}. Sinon une erreur est
générée.

Les arguments \code{times} et \code{each} en sont utilisé que si
\code{date_ts} est manquant (non fourni par l'utilisateur). Si tel est le
cas, ils se comporte comme si \code{replacement} devenait
\code{rep(replacement, times = times, each = each)}.
}
\examples{

ts1 <- ts(
    data = c(rep(NA_integer_, 3L), 1L:10L, rep(NA_integer_, 3L)),
    start = 2020,
    frequency = 12
)
x <- rep(3L, 2L)

extend_ts(series = ts1, replacement = x)
extend_ts(series = ts1, replacement = x, replace_na = FALSE)
extend_ts(series = ts1, replacement = x,
          date_ts_to = c(2021L, 7L), replace_na = TRUE)

}
