% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R
\name{rule}
\alias{rule}
\alias{print.rule}
\title{Creates a single data rule}
\usage{
rule(expr, name = NA, allow_na = FALSE, negate = FALSE, ...)

\method{print}{rule}(x, ...)
}
\arguments{
\item{expr}{an expression which dictates which determines when a rule is good.
Note that the expression is evaluated in \code{check_data()}, within the given
framework. That means, for example if a the data given to \code{check_data()} is
an \code{arrow} dataset, the expression must be mappable from \code{arrow} (see also
\href{https://arrow.apache.org/docs/r/reference/acero.html#function-mappings}{arrow documentation}).
The expression can be given as a string as well.}

\item{name}{an optional name for the rule for reference}

\item{allow_na}{does the rule allow for NA values in the data? default value is FALSE.
Note that when NAs are introduced in the expression, \code{allow_na} has no effect.
Eg when the rule \code{as.numeric(vs) \%in\% c(0, 1)} finds the values of \code{vs} as
\code{c("1", "A")}, the rule will throw a fail regardless of the value of \code{allow_na}
as the NA is introduced in the expression and is not found in the original data.
However, when the values of \code{vs} are \code{c("1", NA)}, \code{allow_na} will have an effect.}

\item{negate}{is the rule negated, only applies to the expression not allow_na,
that is, if \code{expr = mpg > 10}, \code{allow_na = TRUE}, and \code{negate = TRUE}, it would
match all \code{mpg <= 10} as well as NAs.}

\item{...}{additional arguments that are carried along for your documentation,
but are not used. Could be for example date, person, contact, comment, etc}

\item{x}{a rule to print}
}
\value{
The rule values as a list
}
\description{
Creates a single data rule
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(rule)}: Prints a rule

}}
\examples{
r <- rule(mpg > 10)
r

r2 <- rule(mpg > 10, name = "check that mpg is reasonable", allow_na = TRUE,
           negate = FALSE, author = "me", date = Sys.Date())
r2

check_data(mtcars, r)

rs <- ruleset(
  rule(mpg > 10),
  rule(cyl \%in\% c(4, 6)), # missing 8
  rule(qsec >= 14.5 & qsec <= 22.9)
)
rs
check_data(mtcars, rs)
}
