% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{GetCrossValidationScores}
\alias{GetCrossValidationScores}
\title{Get cross validation scores}
\usage{
GetCrossValidationScores(model, partition = NULL, metric = NULL)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{partition}{numeric. Optional. The ID of the partition to filter results by.}

\item{metric}{character. Optional. The name of the metric to filter results by.}
}
\value{
A list of lists with cross validation score data. Each list contains a series of lists
  for each model metric. Each model metric list contains the metric data for each fold.
}
\description{
Get cross validation scores
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  GetCrossValidationScores(model)
}
}
