% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isCPR.R
\name{isCPR}
\alias{isCPR}
\title{Check if a variable consists of Danish CPR numbers}
\usage{
isCPR(v, ...)
}
\arguments{
\item{v}{A variable (vector) to check. This variable is allowed to have any class.}

\item{...}{Not in use.}
}
\value{
A \code{\link{checkResult}} with three entires:
\code{$problem} (a logical indicating whether the variable consists
of CPR numbers), \code{$message} (if a problem was found,
the following message: "Warning: The variable seems to consist of
Danish civil registration (CPR) numbers.",
otherwise "") and \code{$problemValues} (always \code{NULL}).
}
\description{
A \code{\link{checkFunction}} that checks if \code{v} consists exclusively
of valid Danish civil registration (CPR) numbers, ignoring missing values. This
function is intended for use as a precheck in \code{\link{makeDataReport}}, ensuring
that CPR numbers are not included in a \code{dataReporter} output document.
}
\examples{

CPRs <- c("010188-3639", "020187-1476", "040506-8664", "010290-3684", "010291-1180",
          "010293-1599", "010294-1268", "010295-1360", "010296-3970", "010297-2007",
          "010270-2905", "010271-0134", "010272-1403", "010273-3088", "010274-1633")
nonCPRs <- c(1:10)
mixedCPRs <- c(CPRs, nonCPRs)

#identify problem
isCPR(CPRs)

#no problem as there are no CPRs
isCPR(nonCPRs)

#no problem because not ALL values are CPRs
isCPR(mixedCPRs)

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}},
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
