% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\title{Perform checks of potential errors in variable/dataset}
\usage{
check(v, nMax = 10, checks = setChecks(), ...)
}
\arguments{
\item{v}{the vector or the dataset (\code{data.frame}) to be checked.}

\item{nMax}{If a check is supposed to identify problematic values,
this argument controls if all of these should be pasted onto the outputted
message, or if only the first \code{nMax} should be included. If set to \code{Inf}, 
all problematic values are printed.}

\item{checks}{A list of checks to use on each supported variable type. We recommend
using \code{\link{setChecks}} for creating this list and refer to the documentation
of this function for more details.}

\item{\dots}{Other arguments that are passed on to the checking functions.
These includes general parameters controlling how the check results are
formatted (e.g. \code{maxDecimals}, which controls the number of decimals
printed for numerical, problematic values).}
}
\value{
If \code{v} is a variable, a list of objects of class
\code{\link{checkResult}}, which each summarizes the result of a
\code{\link{checkFunction}} call performed on \code{v}.
See \code{\link{checkResult}} for more details. If \code{V} is a
\code{data.frame}, a list of lists of the form above
is returned instead with one entry for each variable in \code{v}.
}
\description{
Run a set of validation checks to check a variable vector or a full dataset
for potential errors.
Which checks are performed depends on the class of the variable and on user
inputs.
}
\details{
It should be noted that the default options for each variable type
are returned by calling e.g. \code{defaultCharacterChecks()},
\code{defaultFactorChecks()}, \code{defaultNumericChecks()}, etc. A complete 
overview of all default options can be obtained by calling \code{setChecks()}. 
Moreover, all available \code{checkFunction}s (including both locally defined
functions and functions imported from \code{dataMaid} or other packages) can
be viewed by calling \code{allCheckFunctions()}.
}
\examples{

x <- 1:5
check(x)

#Annoyingly coded missing as 99
y <- c(rnorm(100), rep(99, 10))
check(y)

#Check y for outliers and print 4 decimals for problematic variables
check(y, checks = setChecks(numeric = "identifyOutliers"), maxDecimals = 4)

#Change what checks are performed on a variable, now only identifyMissing is called
# for numeric variables
check(y, checks = setChecks(numeric = "identifyMissing"))

#Check a full data.frame at once
data(cars)
check(cars)

#Check a full data.frame at once, while changing the standard settings for
#several data classes at once. Here, we ommit the check of miscoded missing values for factors
#and we only do this check for numeric variables:
check(cars, checks = setChecks(factor = defaultFactorChecks(remove = "identifyMissing"),
  numeric = "identifyMissing"))

}
\references{
Petersen AH, Ekstrøm CT (2019). “dataMaid: Your Assistant for Documenting Supervised Data Quality Screening in R.” _Journal of Statistical Software_, *90*(6), 1-38. doi: 10.18637/jss.v090.i06 ( \doi{10.18637/jss.v090.i06}).
}
\seealso{
\code{\link{setChecks}}, 
\code{\link{allCheckFunctions}} \code{\link{checkResult}}
\code{\link{checkFunction}}, \code{\link{defaultCharacterChecks}},
\code{\link{defaultFactorChecks}}, \code{\link{defaultLabelledChecks}},
\code{\link{defaultHavenlabelledChecks}},
\code{\link{defaultNumericChecks}}, \code{\link{defaultIntegerChecks}},
\code{\link{defaultLogicalChecks}}, \code{\link{defaultDateChecks}}
}
\keyword{misc}
