% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_eigenvalues.R
\name{graph_eigenvalues.recipe}
\alias{graph_eigenvalues.recipe}
\title{A helper for sub_dann}
\usage{
\method{graph_eigenvalues}{recipe}(
  x,
  data,
  neighborhood_size = max(floor(nrow(data)/5), 50),
  weighted = FALSE,
  sphere = "mcd",
  ...
)
}
\arguments{
\item{x}{A recipe from recipes library.}

\item{data}{A data frame.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{sphere}{One of "mcd", "mve", "classical", or "none" See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{...}{Additional parameters passed to methods.}
}
\value{
A ggplot2 graph.
}
\description{
A helper for sub_dann
}
\details{
This function plots the eigenvalues found by \code{\link[fpc:ncoord]{fpc::ncoord()}}. The user
should make a judgement call on how many eigenvalues are large and set sub_dann's
numDim to that number.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)
library(recipes)

set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")

# Add 5 unrelated variables
train <- train \%>\%
  mutate(
    U1 = runif(300, -1, 1),
    U2 = runif(300, -1, 1),
    U3 = runif(300, -1, 1),
    U4 = runif(300, -1, 1),
    U5 = runif(300, -1, 1)
  )

rec_obj <- recipe(Y ~ X1 + X2 + U1 + U2 + U3 + U4 + U5, data = train)

graph_eigenvalues(rec_obj, train)
}
