% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_eclat.R
\name{pat_eclat}
\alias{pat_eclat}
\title{ECLAT itemsets}
\usage{
pat_eclat(parameter = list(supp = 0.5, maxlen = 3), control = NULL)
}
\arguments{
\item{parameter}{list of parameters passed to \code{arules::eclat}}

\item{control}{list of control parameters}
}
\value{
returns a \code{pat_eclat} object
}
\description{
Frequent itemsets using \code{arules::eclat}.
}
\examples{
data("AdultUCI", package = "arules")
trans <- suppressWarnings(methods::as(as.data.frame(AdultUCI), "transactions"))
pm <- pat_eclat(parameter = list(supp = 0.5, maxlen = 3))
pm <- fit(pm, trans)
itemsets <- discover(pm)
arules::inspect(itemsets[1:6])
}
