% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_outliers_boxplot.R
\name{outliers_boxplot}
\alias{outliers_boxplot}
\title{Outlier removal by boxplot (IQR rule)}
\usage{
outliers_boxplot(alpha = 1.5)
}
\arguments{
\item{alpha}{boxplot outlier threshold (default 1.5, but can be 3.0 to remove extreme values)}
}
\value{
returns an outlier object
}
\description{
Removes outliers from numeric columns using Tukey's boxplot rule:
values below Q1 - alpha·IQR or above Q3 + alpha·IQR are flagged as outliers.
}
\details{
The default \code{alpha=1.5} corresponds to the standard boxplot whiskers; \code{alpha=3} is used for extreme outliers.
}
\examples{
# code for outlier removal
out_obj <- outliers_boxplot() # class for outlier analysis
out_obj <- fit(out_obj, iris) # computing boundaries
iris.clean <- transform(out_obj, iris) # returning cleaned dataset

#inspection of cleaned dataset
nrow(iris.clean)

idx <- attr(iris.clean, "idx")
table(idx)
iris.outliers_boxplot <- iris[idx,]
iris.outliers_boxplot
}
\references{
Tukey, J. W. (1977). Exploratory Data Analysis. Addison‑Wesley.
}
