% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.R
\name{impliedCovarianceMatrix}
\alias{impliedCovarianceMatrix}
\title{Implied Covariance Matrix of a Gaussian Graphical Model}
\usage{
impliedCovarianceMatrix(
  x,
  b.default = NULL,
  b.lower = -0.6,
  b.upper = 0.6,
  eps = 1,
  standardized = TRUE
)
}
\arguments{
\item{x}{the input graph, a DAG (which may contain bidirected edges).}

\item{b.default}{default path coefficient applied to arrows for which no coefficient is 
defined in the model syntax.}

\item{b.lower}{lower bound for random path coefficients, applied if \code{b.default=NULL}.}

\item{b.upper}{upper bound for path coefficients.}

\item{eps}{residual variance (only meaningful if \code{standardized=FALSE}).}

\item{standardized}{logical. If true, a standardized population covariance matrix
is generated (all variables have variance 1).}
}
\description{
Implied Covariance Matrix of a Gaussian Graphical Model
}
