% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R, R/core_stats.R,
%   R/extended_s3_methods.R
\name{unpack_obj}
\alias{unpack_obj}
\alias{unpack_obj.traces_dm}
\alias{unpack_obj.traces_dm_list}
\alias{unpack_obj.stats_dm}
\alias{unpack_obj.stats_dm_list}
\alias{unpack_obj.coefs_dm}
\title{Unpack/Destroy dRiftDM Objects}
\usage{
unpack_obj(object, ...)

\method{unpack_obj}{traces_dm}(object, ..., unpack_elements = TRUE)

\method{unpack_obj}{traces_dm_list}(object, ..., unpack_elements = TRUE, conds = NULL)

\method{unpack_obj}{stats_dm}(object, ..., unpack_elements = TRUE)

\method{unpack_obj}{stats_dm_list}(object, ..., unpack_elements = TRUE, type = NULL)

\method{unpack_obj}{coefs_dm}(object, ..., unpack_elements = TRUE)
}
\arguments{
\item{object}{an object of type \code{stats_dm}, \code{stats_dm_list}, \code{traces_dm},
\code{traces_dm_list}, or \code{coefs_dm}}

\item{...}{further arguments passed on to the respective method.}

\item{unpack_elements}{logical, indicating if the \code{traces_dm},
\code{stats_dm}, or \code{coefs_dm} objects shall be unpacked. Default is \code{TRUE}.}

\item{conds}{optional character vector, indicating specific condition(s). The
default \code{NULL} will lead to \code{conds = conds(object)}. Thus, per default all
conditions are addressed}

\item{type}{optional character vector, indicating specific type(s) of
statistics. The default \code{NULL} will access all types of statics.}
}
\value{
For \code{traces_dm_list}, the returned value is a list, if \code{conds} specifies more
than one condition. For example, if \code{conds = c("foo", "bar")}, then the
returned value is a list with the two (named) entries "foo" and "bar". If
the returned list would only have one entry (either because the
\code{traces_dm_list} has only one condition, see \link{conds}, or because a
user explicitly requested only one condition), then the underlying
\link{array} or \code{traces_dm} object is returned directly.

For \code{stats_dm_list}, the returned value is a list, if \code{type} specifies more
than one condition. If the returned list would only have one entry, then
the underlying \link{data.frame} or \code{stats_dm} object is returned directly.

For \code{traces_dm}, \code{unpack_obj()} returns an \link{array} with the traces, if
\code{unpack=TRUE}. If \code{unpack=FALSE}, the unmodified object is returned.

For \code{stats_dm}, \code{unpack_obj()} returns a \link{data.frame} with the respective
statistic, if \code{unpack=TRUE}. If \code{unpack=FALSE}, the unmodified object is
returned.

For \code{coefs_dm}, \code{unpack_obj()} returns a \link{data.frame} with the
parameters, if \code{unpack=TRUE}. If \code{unpack=FALSE}, the unmodified object is
returned.
}
\description{
When calling \code{\link[=simulate_traces]{simulate_traces()}}, \link{calc_stats}, or
\link{coef.fits_ids_dm} the returned objects will be custom objects
(e.g., subclasses of \link{list} or \link{data.frame}). The respective subclasses were
created to provide convenient plotting and printing, but they don't
really provide any additional functionality.

The goal of \code{unpack_obj()} is to provide a convenient way to strip away
the attributes of the respective objects (revealing them as standard
\link{array}s, \link{data.frame}s, or \link{list}s).
}
\details{
\code{unpack_obj()} is a generic function to strip away the custom information
and class labels of \code{stats_dm}, \code{stats_dm_list}, \code{traces_dm},
\code{traces_dm_list}, and \code{coefs_dm} objects. These objects are created when
calling \code{\link[=simulate_traces]{simulate_traces()}}, \link{calc_stats}, or
\link{coef.fits_ids_dm}.

For \code{traces_dm_list}, \code{unpack_obj()} returns the
requested conditions (see the argument \code{conds}). The result contains
objects of type \code{traces_dm} if \code{unpack_elements = FALSE}. For
\code{unpack_elements = TRUE}, the result contains the plain \link{array}s with the
traces.

For \code{stats_dm_list}, \code{unpack_obj()} returns the
requested statistics (see the argument \code{type}). The result contains
objects of type \code{stats_dm} if \code{unpack_elements = FALSE}. For
\code{unpack_elements = TRUE}, the result contains the plain \link{data.frame}s with
the statistics.
}
\examples{
# get a pre-built model to demonstrate the function
my_model <- dmc_dm()

# get some traces ...
some_traces <- simulate_traces(my_model, k = 2, seed = 1)
some_traces <- some_traces$comp
class(some_traces)
# ... unpack them to get the underlying arrays
class(unpack_obj(some_traces))

# get some statistics ...
some_stats <- calc_stats(my_model, type = "cafs")
class(some_stats)
class(unpack_obj(some_stats))

# get some parameters ...
some_coefs <- coef(get_example_fits("fits_ids_dm"))
class(some_coefs)
class(unpack_obj(some_coefs))

}
