% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_fits_agg_dm.R
\name{print.summary.fits_agg_dm}
\alias{print.summary.fits_agg_dm}
\alias{summary.fits_agg_dm}
\title{Summary and Printing for \code{fits_agg_dm} Objects}
\usage{
\method{print}{summary.fits_agg_dm}(x, ..., just_header = FALSE, round_digits = drift_dm_default_rounding())

\method{summary}{fits_agg_dm}(object, ..., select_unique = FALSE)
}
\arguments{
\item{x}{an object of class \code{summary.fits_agg_dm}.}

\item{...}{additional arguments (currently unused).}

\item{just_header}{logical, if \code{TRUE} only print the header information
without details. Default is \code{FALSE}.}

\item{round_digits}{an integer, specifying the number of decimal places for
rounding in the printed summary. Default is 3.}

\item{object}{an object of class \code{fits_agg_dm}, typically generated by a call
to \link{estimate_dm}.}

\item{select_unique}{logical, passed to \code{\link[=coef.drift_dm]{coef.drift_dm()}}.}
}
\value{
\code{summary.fits_agg_dm()} returns a list of class \code{summary.fits_agg_dm}
(see Details for its structure).

\code{print.summary.fits_agg_dm()} returns the input object invisibly.
}
\description{
Methods for summarizing and printing objects of the class \code{fits_agg_dm},
which contain model fits based on aggregated data across participants.
}
\details{
The \code{summary.fits_agg_dm} function creates a structured summary of a
\code{fits_agg_dm} object, containing:
\itemize{
\item \strong{summary_drift_dm_obj}: A list with information about the underlying
drift diffusion model (as returned by \code{\link[=summary.drift_dm]{summary.drift_dm()}}).
\item \strong{prms}: Parameter estimates obtained from the model fit.
This is equivalent to a call to \code{\link[=coef.drift_dm]{coef.drift_dm()}} on the stored
model object.
\item \strong{obs_data}: A list providing the number of individual participants and
the average number of trials per condition across participants.
}

The \code{print.summary.fits_agg_dm} function formats and prints the above summary
in a human-readable form.
}
\examples{
# Load example fit object
fits_agg <- get_example_fits("fits_agg")
sum_obj <- summary(fits_agg)
print(sum_obj, round_digits = 2)

}
\seealso{
\link{summary.drift_dm}, \link{coef.drift_dm}
}
