% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_estimate.R
\name{set_agg_data}
\alias{set_agg_data}
\title{Set aggregated data to a model object}
\usage{
set_agg_data(drift_dm_obj, obs_data_ids, ...)
}
\arguments{
\item{drift_dm_obj}{a model object (of class \code{drift_dm}) to which the
aggregated data will be attached.}

\item{obs_data_ids}{a data.frame containing individual-level observations.
Must include an \code{ID} column identifying participants.}

\item{...}{optional arguments (currently supported are \code{n_bins} and
\code{probs} which are relevant when using the \code{rmse} cost function)}
}
\value{
The updated \code{drift_dm_obj} with aggregated \code{stats_agg} and
\code{obs_data} set to \code{NULL}.
}
\description{
Helper function that aggregates a data set across all participants
and attaches the resulting group-level summary statistics to a
\code{drift_dm_obj}. This is required when the user wants to fit aggregated data
(e.g., via the RMSE cost function).
}
\details{
This function is intended for internal use and is called by
\code{\link[=estimate_dm]{estimate_dm()}} when aggregated model fitting is requested.
}
\keyword{internal}
