% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.quantiles}
\alias{plot.quantiles}
\title{Plot Response Time Quantiles}
\usage{
\method{plot}{quantiles}(
  x,
  ...,
  id = NULL,
  conds = NULL,
  dv = NULL,
  col = NULL,
  xlim = NULL,
  ylim = c(0, 1),
  xlab = "RT [s]",
  ylab = "F(RT)",
  interval_obs = TRUE,
  interval_pred = TRUE
)
}
\arguments{
\item{x}{an object of \code{type = "quantiles"}, typically returned by
\code{\link[=calc_stats]{calc_stats()}}.}

\item{...}{additional graphical arguments passed to plotting functions.
See \code{\link[=set_default_arguments]{set_default_arguments()}} for the full list of supported
options.}

\item{id}{a numeric or character, specifying the ID of a single participant
to plot. If \code{length(id) > 1}, \code{plot.cafs()} is called recursively for
each entry. Each \code{id} must match an entry in the \code{ID} column of \code{x}.}

\item{conds}{a character vector specifying the conditions to plot.
Defaults to all available conditions.}

\item{dv}{a character string indicating the dependent variable to plot.
Defaults to the quantiles for the upper boundary.}

\item{col}{a character vector specifying colors for each condition. If a
single color is provided, it is repeated for all conditions.}

\item{xlim}{a numeric vector of length 2, specifying the x-axis limits.}

\item{ylim}{a numeric vector of length 2, specifying the y-axis limits.}

\item{xlab, ylab}{character strings for the x- and y-axis labels.}

\item{interval_obs, interval_pred}{logicals; if \code{TRUE} and \code{x} contains a
column named \code{Estimate}, error bars for observed data and shaded contours
for predicted data are drawn, respectively.}
}
\value{
Returns \code{NULL} invisibly. The function is called for its side effect of
generating a plot.
}
\description{
Visualizes response time quantiles for observed and/or predicted data across
experimental conditions. This is useful for assessing model fit or exploring
response patterns across conditions or participants.
}
\details{
If \code{x} contains multiple \code{ID}s and no specific \code{id} is provided, the
function aggregates across participants before plotting.

Observed quantiles are shown as points, and predicted quantiles as lines.
When \code{interval = TRUE} and the input includes interval estimates (i.e., the
column \code{Estimate} exists), the plot includes error bars for observed data
and shaded contours for model predictions.

Colors, symbols, and line styles can be customized via \code{...}.
}
\examples{
# Example 1: Model predictions only ---------------------------------------
a_model <- dmc_dm()
quantiles <- calc_stats(a_model, type = "quantiles")
plot(quantiles)
plot(quantiles, col = c("green", "red"), xlim = c(0.2, 0.6))

# Example 2: Observed and predicted data ----------------------------------
obs_data(a_model) <- dmc_synth_data
quantiles <- calc_stats(a_model, type = "quantiles")
plot(quantiles)

# Example 3: Observed data only -------------------------------------------
quantiles <- calc_stats(dmc_synth_data, type = "quantiles")
plot(quantiles)

# Example 4: Observed data with interval ----------------------------------
cafs <- calc_stats(dmc_synth_data, type = "quantiles", resample = TRUE)
plot(cafs)

}
