% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{conds<-}
\alias{conds<-}
\alias{conds<-.drift_dm}
\alias{conds}
\alias{conds.drift_dm}
\alias{conds.fits_ids_dm}
\alias{conds.fits_agg_dm}
\alias{conds.data.frame}
\alias{conds.traces_dm_list}
\title{The Conditions of an Object}
\usage{
conds(object, ...) <- value

\method{conds}{drift_dm}(object, ..., eval_model = FALSE, messaging = TRUE) <- value

conds(object, ...)

\method{conds}{drift_dm}(object, ...)

\method{conds}{fits_ids_dm}(object, ...)

\method{conds}{fits_agg_dm}(object, ...)

\method{conds}{data.frame}(object, ...)

\method{conds}{traces_dm_list}(object, ...)
}
\arguments{
\item{object}{an \code{R} object, see details}

\item{...}{additional arguments passed forward.}

\item{value}{a character vector, providing labels for the model's new
conditions.}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when updating the conditions (see \link{re_evaluate_model}).
Default is \code{FALSE}.}

\item{messaging}{logical, indicating if messages shall be displayed or not.}
}
\value{
For \code{conds()} \code{NULL} or a character vector with the conditions. \code{NULL} is
given if the object has no conditions (e.g., when a data.frame has no \code{Cond}
column).

For \verb{conds<-()} the updated \link{drift_dm} object.
}
\description{
Extract the conditions from a (supported) object.
}
\details{
\code{conds()} is a generic accessor function and \verb{conds<-()} is a
generic replacement function. The replacement method currently only supports
\link{drift_dm} objects. The default methods get and set the conditions
of an object.

When replacing the conditions of a \link{drift_dm} object, a
new \link{flex_prms} object is created and then set to the model,
resetting all parameter specifications and setting all parameter
values to those of the previously first condition.
In addition, if data was attached to the model, the data is removed.
This is because there is no meaningful way for dRiftDM to know how the model
should behave for the newly introduced condition(s), and how these new
conditions relate to the old ones. Messages reminding the user of this
behavior are displayed per default.
}
\examples{
# get a pre-built model to demonstrate the conds() function
my_model <- dmc_dm()
conds(my_model)

# accessor functions also work with other object types provided by dRiftDM
# (simulated traces; see the documentation of the respective function)
some_traces <- simulate_traces(my_model, k = 1)
conds(some_traces)

# get an exemplary fits_ids_dm object (see estimate_model_ids)
fits <- get_example_fits("fits_ids_dm")
conds(fits)

# also works with data.frames that have a "Cond" column
conds(dmc_synth_data)

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
