% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R, R/extended_s3_methods.R,
%   R/formatting_coefs_dm.R
\name{coef<-}
\alias{coef<-}
\alias{coef<-.drift_dm}
\alias{coef.drift_dm}
\alias{coef.fits_agg_dm}
\alias{coef.fits_ids_dm}
\alias{coef.mcmc_dm}
\alias{print.coefs_dm}
\title{Access Coefficients of a Model}
\usage{
coef(object, ...) <- value

\method{coef}{drift_dm}(object, ..., eval_model = FALSE) <- value

\method{coef}{drift_dm}(object, ..., select_unique = TRUE, select_custom_prms = TRUE)

\method{coef}{fits_agg_dm}(object, ...)

\method{coef}{fits_ids_dm}(object, ...)

\method{coef}{mcmc_dm}(object, ..., .f = mean, id = NULL)

\method{print}{coefs_dm}(
  x,
  ...,
  round_digits = drift_dm_default_rounding(),
  print_rows = 10,
  some = FALSE,
  show_header = TRUE,
  show_note = TRUE
)
}
\arguments{
\item{object}{an object of type \link{drift_dm}, \code{fits_agg_dm},
\code{fits_ids_dm} (see also \code{\link[=estimate_dm]{estimate_dm()}}), or \code{mcmc_dm}.}

\item{...}{additional arguments passed forward (to \code{coef.drift_dm()} for
objects of type \code{fits_agg_dm}; to \code{.f} for objects of type \code{mcmc_dm}.}

\item{value}{numerical, a vector with valid values to update the model's
parameters. Must match with the number of (unique and free) parameters.}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when updating the parameters (see \link{re_evaluate_model}).
Default is \code{FALSE}.}

\item{select_unique}{logical, indicating if only those parameters shall be
returned that are considered unique (e.g., when a parameter is set to be
identical across three conditions, then the parameter is only returned once).
Default is \code{TRUE}. This will also return only those parameters that are
estimated. The argument is currently not supported for objects of type
\code{mcmc_dm}.}

\item{select_custom_prms}{logical, indicating if custom parameters shall be
returned as well. Only has an effect if \code{select_unique = FALSE}.
The argument is currently not supported for objects of type
\code{mcmc_dm}.}

\item{.f}{the function to be applied to each parameter of a chain. Must
either return a single value or a vector (with always the same length).
Default is \code{mean} (i.e., the mean function).}

\item{id}{an optional numeric or character vector specifying the IDs of
participants from whom to summarize samples. Only applicable when the model was
estimated hierarchically. Use \code{id = NA} as a shorthand to summarize samples
for all individuals in the chain object.}

\item{x}{an object of type \code{coefs_dm}, as returned by the function
\code{coef()} when supplied with a \code{fits_ids_dm} object.}

\item{round_digits}{integer, controls the number of digits shown.
Default is 3.}

\item{print_rows}{integer, controls the number of rows shown.}

\item{some}{logical. If \code{TRUE}, a subset of randomly sampled rows is shown.}

\item{show_header}{logical. If \code{TRUE}, a header specifying the type of
statistic will be displayed.}

\item{show_note}{logical. If \code{TRUE}, a footnote  is displayed indicating
that the underlying \link{data.frame} can be accessed as usual.}
}
\value{
For objects of type \link{drift_dm}, \code{coefs()} returns either a named
numeric vector if \code{select_unique = TRUE}, or a matrix if
\code{select_unique = FALSE}. If \code{select_custom_prms = TRUE}, custom parameters
are added to the matrix.

For objects of type \code{fits_ids_dm}, \code{coefs()} returns a \link{data.frame}. If
\code{select_unique = TRUE}, the columns will be the (unique, free) parameters,
together with a column coding \code{IDs}. If \code{select_unique = FALSE}, the columns
will be the parameters as listed in the columns of \code{prms_matrix} (see
\link{drift_dm}), together with columns coding the conditions and
\code{IDs}. If \code{select_custom_prms = TRUE}, the \link{data.frame} will also contain
columns for the custom parameters. The returned \link{data.frame} has the class
label \code{coefs_dm} to easily plot histograms for each parameter
(see \link{hist.coefs_dm}).

For objects of type \code{fits_agg_dm}, returns the same as \code{coef.drift_dm()}
(i.e., as if calling \code{coef()} with an object of type \code{drift_dm})

For objects of type \code{mcmc_dm}, the return type depends on the model structure
and the \code{.f} output:
\itemize{
\item If the model is non-hierarchical or \code{id} is a single value (not \code{NA}),
the function returns either a \code{vector} or a \code{matrix}, depending on whether
\code{.f} returns a single value or a vector.
\item In the hierarchical case, when \code{id} is a vector or \code{NA}, the function
returns a \code{data.frame}. If \code{.f} returns a single value, the \code{data.frame}
will contain one row per participant (with an \code{ID} column and one column
per parameter). If \code{.f} returns a vector, the \code{data.frame} will include
an additional column \code{.f_out}, coding the output of \code{.f} in long
format.
}
}
\description{
Extract or set the coefficients/parameters objects supported by \link{dRiftDM}.
}
\details{
\verb{coef.*()} are methods for the generic \code{\link[stats:coef]{stats::coef()}} function; \verb{coefs<-()}
is a generic replacement function, currently supporting objects of type
\link{drift_dm}.

The argument \code{value} supplied to the \verb{coefs<-()} function must match with
the vector returned from \verb{coef(<object>)}. It is possible to
update just part of the (unique) parameters.

Whenever the argument \code{select_unique} is \code{TRUE}, \code{dRiftDM} tries to provide
unique parameter labels.
}
\examples{
# get a pre-built model and a data set for demonstration purpose
# (when creating the model, set the discretization to reasonable values)
a_model <- dmc_dm()
coef(a_model) # gives the free and unique parameters
coef(a_model, select_unique = FALSE) # gives the entire parameter matrix

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
