% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.input_data.R
\name{read_sample}
\alias{read_sample}
\title{Read sample files}
\usage{
read_sample(
  sample.table,
  system = NULL,
  file.location = ".",
  sample.quality = 0.5,
  partition.volume = NULL
)
}
\arguments{
\item{sample.table}{object of class \code{sample_table}, inherited from
\code{\link{read_sampleTable}}.}

\item{system}{character. The name of digital PCR system used to generate
the data. It must be either Thermo Fisher or Bio-Rad. Abbreviations are
also accepted.}

\item{file.location}{character. Full path name to reference and sample
files location. The default corresponds to the working directory,
(\code{\link[base]{getwd}}). Tilde expansion (see
(\code{\link[base]{path.expand}})) is performed.}

\item{sample.quality}{numeric. Between 0 and 1. Quality threshold to subset
data. If different thresholds have to be applied to various samples, a
vectror of the same length of number of samples has to be provided. Used
only when the \code{system} is Thermo Fisher.}

\item{partition.volume}{numeric. This parameters is taken into account when
the parameter 'system' is set on Other. Indicate the partion volume in
microliters spcific to the digital PCR system.}
}
\value{
An object of class \code{read_sample} containing a sublist for each
  sample. Each sublist has the following components:
  \item{quality}{value of the \code{sample.quality} parameter.}
  \item{data}{a matrix with the fluorescence intensities and quality
  values.}
}
\description{
This function reads the results files of samples listed in the sample table.
Fluoresce intensity and quality value (just for Thermo Fisher) are
collected.
}
\examples{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata", package = "dPCP")

#Read sample table file
sample.table <- read_sampleTable(sampleTable, system = "bio-rad",
                                 file.location = fileLoc)

#Read reference files
ref <- read_reference(sample.table, system = "bio-rad",
                      file.location = fileLoc)

#Read samples files
samp <- read_sample(sample.table, system = "bio-rad",
                    file.location = fileLoc)
}
