% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{wasserstein}
\alias{wasserstein}
\title{Calculate the Wasserstein Distance}
\usage{
wasserstein(
  copula,
  copula2 = NULL,
  theta = NULL,
  x = NULL,
  n_grid = 2500,
  p = 2
)
}
\arguments{
\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}'.
or '\code{\link[copula:Copula-class]{Copula}}' (package '\pkg{copula}', only 2-dimensional).}

\item{copula2}{\R object of class '\code{\linkS4class{cyl_copula}}'.
or '\code{\link[copula:Copula-class]{Copula}}' (package '\pkg{copula}', only 2-dimensional).}

\item{theta}{(alternatively) \link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable) or "circular" component of pseudo-observations.}

\item{x}{(alternatively) \link[base]{numeric} \link[base]{vector} of step lengths
(measurements of a linear variable) or "linear" component of pseudo-observations.}

\item{n_grid}{\link[base]{integer} number of grid cells at which the PDF of the copula(s) is calculated
Default is 2500}

\item{p}{\link[base]{integer} power (1 or 2) to which the Euclidean distance
between points is taken in order to compute transportation costs.}
}
\value{
\link[base]{numeric}, the pth Wasserstein distance
}
\description{
The Wasserstein distance is calculated based on the Euclidean distance
between two copula PDFs on a grid, or between a copula PDF and
pseudo-observations.
}
\details{
Note that when comparing 2 copula PDFs (i.e. \code{theta = NULL} and \code{x = NULL}),
the calculated Wasserstein distance will depend on the number of grid cells
(\code{n_grid}) used to approximate the PDFs. The distance will converge to a certain
value with a higher number of grid cells, but the computational time will also increase.
The default of 2500 seems to be a good (empirically determined) compromise.
The same is true when calculating the Wasserstein distance between a copula
PDF and pseudo-observations. There, it is also important to only compare distances
that use the same number of observations.

The code is based on the functions \code{transport::\link[transport]{wasserstein}()}
and \code{transport::\link[transport]{semidiscrete}()}.
}
\examples{
set.seed(1234)
copula1 <- cyl_quadsec(0.1)
copula2 <- cyl_rect_combine(copula::frankCopula(2))
wasserstein(copula=copula1,copula2 = copula2,p=2,n_grid=20)
wasserstein(copula=copula1,copula2 = copula1,p=2,n_grid=20)
wasserstein(copula=copula1,copula2 = copula::frankCopula(2),p=2,n_grid=20)

 sample <- rjoint(10,
  copula1,
  marginal_1 = list(name = "vonmises", coef  = list(0, 1)),
  marginal_2 = list(name = "weibull", coef = list(3,4))
)

wasserstein(copula=copula1, theta=sample[,1], x=sample[,2], n_grid=20)
}
