% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_cmfitlist.R
\name{summary.cmfitlist}
\alias{summary.cmfitlist}
\title{Summary method for cmfitlist objects}
\usage{
\method{summary}{cmfitlist}(object, ..., coefs = TRUE)
}
\arguments{
\item{object}{a \code{cmfitlist} object - output of \code{\link{select_seasons}}}

\item{...}{(currently not implemented)}

\item{coefs}{whether or not to return model coefficients along with statistic test table.}
}
\value{
a data frame describing the AIC, log-likelihood, number of parameters and parameter estimates for each model
}
\description{
Summary method for cmfitlist objects
}
\examples{
T.morts1 <- simulate_cycloSurv(1000, period = 1, 
                             meanhazard = 0.3, 
                             peaks = c(0.25, 0.75), 
                             durations = c(0.2, 0.1), 
                             weights = c(0.3, 0.7), 
                             plotme = FALSE)

\donttest{
model_selection = select_seasons(T.morts1, max.season = 4)
summary(model_selection$fits)
}
}
