% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocumentation.R
\docType{data}
\name{nwt_morts}
\alias{nwt_morts}
\title{Mortality data for Northwest territory boreal woodland caribou.}
\format{
Data frame with 370 rows and the following columns:
\describe{
  \item{id}{ID of animal}
  \item{start}{Date of beginning of collaring}
  \item{end}{Date of death or censoring}
  \item{status}{"Mort" or "Cens" (dead or censored)}
  }
}
\source{
Government of Northwest Territories, Canada
}
\usage{
data(nwt_morts)
}
\description{
Mortality data for Northwest territory boreal woodland caribou, anonymized 
and randomized by year, thereby retaining the multi-seasonal signal without, 
with grateful acknowledgements to A. Kelly and N. Larter.
}
\examples{
data(nwt_morts)
require(ggplot2); require(magrittr); require(plyr)
ggplot(nwt_morts \%>\% arrange(start) \%>\% mutate(id = factor(id, levels = id)),
aes(x = start, y = id, col = status)) +
  geom_errorbarh(aes(xmin = start, xmax = end))

}
\keyword{data}
