% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{draw_bezier}
\alias{draw_bezier}
\title{Draw a Bezier Curve}
\usage{
draw_bezier(start, end, c1, c2 = NULL, n = 50, text = "x", ...)
}
\arguments{
\item{start}{starting \code{(row, col)} coordinate}

\item{end}{ending \code{(row, col)} coordinate}

\item{c1}{coordinate of first control point}

\item{c2}{coordinate of second control point}

\item{n}{number of points along curve to calculate}

\item{text}{character value drawn at coordinate}

\item{...}{parameters that are passed to \code{style()}, including the foreground color \code{fg}, background color \code{bg}, and attribute \code{attr}}
}
\value{
\code{NULL}
}
\description{
Calculate the path of a Bezier Curve with up to two control points in a grid and draw to screen.
}
\examples{
draw_bezier(start=c(10,1), end=c(10,10), c1=c(1, 3))

}
\seealso{
Other drawing functions: 
\code{\link{box_at}()},
\code{\link{draw_arc}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_fn}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_ray}()},
\code{\link{draw_rect}()},
\code{\link{draw_shape}()},
\code{\link{fill_circle}()},
\code{\link{fill_ellipse}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{grid_mat}()},
\code{\link{hline_at}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
