% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{load_map}
\alias{load_map}
\title{Load metadata table}
\usage{
load_map(x, sample_col, source_col)
}
\arguments{
\item{x}{Path to a TSV file or tidy dataframe (e.g. tibble) with a column
containing sample names and other grouping metadata columns.}

\item{sample_col}{A column name specifying which column should be used to
specify sample names.}

\item{source_col}{A column name specifying which group or the source the
sample is from.}
}
\value{
A tibble, formatted for use in downstream cuperdec functions.
}
\description{
Loads a metadata table and reformats it for downstream analysis. This needs
to include at minimum two columns: sample name, and sample source.
}
\details{
The two columns required need to include the following information:
\itemize{
  \item{Sample name - a unique identifier for each sample}
  \item{Sample source - a grouping ID indicating what 'source' the sample is
  from This is used for plotting to separate comparative 'sources' to your
  own samples.}
}
}
\examples{
data(cuperdec_metadata_ex)
metadata_table <- load_map(cuperdec_metadata_ex,
  sample_col = "#SampleID",
  source_col = "Env"
)
}
