% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso.R
\name{cuda_ml_lasso}
\alias{cuda_ml_lasso}
\alias{cuda_ml_lasso.default}
\alias{cuda_ml_lasso.data.frame}
\alias{cuda_ml_lasso.matrix}
\alias{cuda_ml_lasso.formula}
\alias{cuda_ml_lasso.recipe}
\title{Train a linear model using LASSO regression.}
\usage{
cuda_ml_lasso(x, ...)

\method{cuda_ml_lasso}{default}(x, ...)

\method{cuda_ml_lasso}{data.frame}(
  x,
  y,
  alpha = 1,
  max_iter = 1000L,
  tol = 0.001,
  fit_intercept = TRUE,
  normalize_input = FALSE,
  selection = c("cyclic", "random"),
  ...
)

\method{cuda_ml_lasso}{matrix}(
  x,
  y,
  alpha = 1,
  max_iter = 1000L,
  tol = 0.001,
  fit_intercept = TRUE,
  normalize_input = FALSE,
  selection = c("cyclic", "random"),
  ...
)

\method{cuda_ml_lasso}{formula}(
  formula,
  data,
  alpha = 1,
  max_iter = 1000L,
  tol = 0.001,
  fit_intercept = TRUE,
  normalize_input = FALSE,
  selection = c("cyclic", "random"),
  ...
)

\method{cuda_ml_lasso}{recipe}(
  x,
  data,
  alpha = 1,
  max_iter = 1000L,
  tol = 0.001,
  fit_intercept = TRUE,
  normalize_input = FALSE,
  selection = c("cyclic", "random"),
  ...
)
}
\arguments{
\item{x}{Depending on the context:

  * A __data frame__ of predictors.
  * A __matrix__ of predictors.
  * A __recipe__ specifying a set of preprocessing steps
  * created from [recipes::recipe()].
  * A __formula__ specifying the predictors and the outcome.}

\item{...}{Optional arguments; currently unused.}

\item{y}{A numeric vector (for regression) or factor (for classification) of
desired responses.}

\item{alpha}{Multiplier of the L1 penalty term (i.e., the result would become
and Ordinary Least Square model if \code{alpha} were set to 0). Default: 1.}

\item{max_iter}{The maximum number of coordinate descent iterations.
Default: 1000L.}

\item{tol}{Stop the coordinate descent when the duality gap is below this
threshold. Default: 1e-3.}

\item{fit_intercept}{If TRUE, then the model tries to correct for the global
mean of the response variable. If FALSE, then the model expects data to be
centered. Default: TRUE.}

\item{normalize_input}{Ignored when \code{fit_intercept} is FALSE. If TRUE,
then the predictors will be normalized to have a L2 norm of 1.
Default: FALSE.}

\item{selection}{If "random", then instead of updating coefficients in cyclic
order, a random coefficient is updated in each iteration. Default: "cyclic".}

\item{formula}{A formula specifying the outcome terms on the left-hand side,
and the predictor terms on the right-hand side.}

\item{data}{When a __recipe__ or __formula__ is used, \code{data} is
specified as a  __data frame__ containing the predictors and (if
applicable) the outcome.}
}
\value{
A LASSO regressor that can be used with the 'predict' S3 generic to
  make predictions on new data points.
}
\description{
Train a linear model using LASSO (Least Absolute Shrinkage and Selection
Operator) regression.
}
\examples{

library(cuda.ml)

model <- cuda_ml_lasso(formula = mpg ~ ., data = mtcars, alpha = 1e-3)
cuda_ml_predictions <- predict(model, mtcars)

# predictions will be comparable to those from a `glmnet` model with `lambda`
# set to 1e-3 and `alpha` set to 1
# (in `glmnet`, `lambda` is the weight of the penalty term, and `alpha` is
#  the elastic mixing parameter between L1 and L2 penalties.

library(glmnet)

glmnet_model <- glmnet(
  x = as.matrix(mtcars[names(mtcars) != "mpg"]), y = mtcars$mpg,
  alpha = 1, lambda = 1e-3, nlambda = 1, standardize = FALSE
)

glm_predictions <- predict(
  glmnet_model, as.matrix(mtcars[names(mtcars) != "mpg"]),
  s = 0
)

print(
  all.equal(
    as.numeric(glm_predictions),
    cuda_ml_predictions$.pred,
    tolerance = 1e-2
  )
)
}
