% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctbi.cycle.R
\name{ctbi.cycle}
\alias{ctbi.cycle}
\title{ctbi.cycle}
\usage{
ctbi.cycle(data0, bin.size, outliers.checked)
}
\arguments{
\item{data0}{data.table with the columns x (time series), y (values), time.bin (position of x between 0 and 1 with respect to the bin boundaries), cycle.index (index between 1 and bin.size attached to time.bin), and long.term (the long-term trend)}

\item{bin.size}{median number of points within all non-empty bins}

\item{outliers.checked}{boolean to indicate if the median (outliers.checked = FALSE) or the mean (outliers.checked = TRUE) should be used to calculate the stack}
}
\value{
A list that contains data0 (data0.l) and a data.table that contains the mean (or median) stack of all accepted bins (FUN.cycle.l)
}
\description{
Calculate the mean (or median) stack of the detrended data for all bins, and add the cyclic component column to data0.
}
\examples{
library(data.table)
x <- seq(from=as.Date('2001-01-01'),to=as.Date('2010-12-01'),by='1 month')
y <- 3*cos(2*pi*(0:(length(x)-1))/12)+runif(length(x))
bin.size <- 12
outliers.checked <- TRUE
time.bin <- rep(((1:bin.size)/bin.size)-(1/(2*bin.size)),10)
cycle.index <- findInterval(time.bin,(1:(bin.size-1))/bin.size)+1
long.term <- rep(0,length(x))
data0 <- data.table(x=x,y=y,cycle.index=cycle.index,long.term=long.term,time.bin=time.bin)
list.cycle <- ctbi.cycle(data0,bin.size,outliers.checked)
data0.with.cyclic.component <- list.cycle$data0.l
mean.cycle <- list.cycle$FUN.cycle.l
}
