% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_plot.R
\name{corr_plot}
\alias{corr_plot}
\title{Create correlation plots of CSPP data}
\usage{
corr_plot(
  data = NULL,
  vars = NULL,
  summarize = TRUE,
  labels = TRUE,
  label_size = 3,
  colors = c("#6D9EC1", "#FFFFFF", "#E46726"),
  cor_matrix = FALSE
)
}
\arguments{
\item{data}{A dataframe. If data is generated by \code{get_cspp_data}
function, the function can automatically parse the dataframe. Otherwise,
this function will attempt to make a correlation plot or matrix from all
numeric variables within the passed dataframe.}

\item{vars}{Default is NULL. If left NULL, uses all variables within the
passed dataframe. Otherwise, must be a character vector. The dataframe is
subset based on variables listed.}

\item{summarize}{Default is TRUE. If TRUE, and if the variable \code{st}
is present, the function will create state specific averages for each
variable in the dataframe. If FALSE, the function will generate the
correlation matrix and plot for all values in the dataset.}

\item{labels}{Default is TRUE. If TRUE, the correlation plot will include
labels for the correlation value. If FALSE, no labels will be present.}

\item{label_size}{Default is 3. Controls the size of the font for labels.}

\item{colors}{Specify the colors to be used in the correlation plot. Must
include three values in a character vector format. The default values are
`c("#6D9EC1", "#FFFFFF", "#E46726")`.}

\item{cor_matrix}{Default is FALSE. If set to TRUE, instead of returning a
ggplot object that is a correlation plot, returns a correlation matrix.
This is particularly useful if you want to customize the output with
\code{ggcorrplot}.}
}
\value{
ggplot2 object or correlation matrix
}
\description{
\code{corr_plot} takes CSPP data from \code{\link{get_cspp_data}} and returns
either a correlation matrix or correlation plot.
}
\details{
This function is a wrapper that passes a dataframe to the
\code{ggcorrplot::ggcorrplot} function which generates correlation heat
plots.
}
\examples{

corr_plot(data = get_cspp_data(), vars = c("pollib_median",
 "innovatescore_boehmkeskinner", "citi6013", "ranney4_control", "h_diffs"),
 cor_matrix = FALSE)
}
\seealso{
\code{ggcorrplot}
}
