% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{csa.multiplot}
\alias{csa.multiplot}
\title{Multiple CSA plotting}
\usage{
csa.multiplot(df, log_x = TRUE, log_y = TRUE, wn = FALSE, smooth = FALSE)
}
\arguments{
\item{df}{A matrix or data.frame composed of three columns;
scale for the temporal or spatial scale; value for the estimate of a given statistic (e.g., variance) at the given aggregated scale and
variable for defining the corresponding dataset.}

\item{log_x}{logical. If TRUE (the default) the x axis of the CSA plot is set to the logarithmic scale.}

\item{log_y}{logical. If TRUE (the default) the y axis of the CSA plot is set to the logarithmic scale.}

\item{wn}{logical. The argument wn (default FALSE) is used to plot a line presenting the standardized variance of the white noise process.
Therefore, it should be used only with stat = "var" and std = T in the csa/csas functions.}

\item{smooth}{logical. If TRUE (the default) the aggregation curves are smoothed (loess function).}
}
\value{
The CSA plot as a ggplot object.
}
\description{
Function for plotting multiple CSA curves in a single plot.
}
\examples{
\donttest{
aa <- rnorm(1000)
csa_aa <- data.frame(csa(aa, plot = FALSE, chk = TRUE), variable = 'wn')
bb <- as.numeric(arima.sim(n = 1000, list(ar = c(0.8897, -0.4858), ma = c(-0.2279, 0.2488))))
csa_bb <- data.frame(csa(bb, plot = FALSE, chk = TRUE), variable = 'arma(2, 2)')
csa.multiplot(rbind(csa_aa, csa_bb), wn = TRUE)
csa.multiplot(rbind(csa_aa, csa_bb), wn = TRUE, smooth = TRUE)
}
}
