% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-export.R
\name{getAnomaly}
\alias{getAnomaly}
\title{getAnomaly function}
\usage{
getAnomaly(
  ncfile,
  poly = NULL,
  timeRange = NULL,
  offset = "1900-01-01",
  na.rm = FALSE
)
}
\arguments{
\item{ncfile}{character string giving name and location of the CRUTS time series NetCDF file (if the file you downloaded is zipped, then you will need to extract it)}

\item{poly}{an optional SpatialPolygonsDataFrame on which to compute the average anomalies if NULL (the default) a raster brick will be returned}

\item{timeRange}{vector of length 2 giving the start and end dates in the first and second place. Dates are converted using the function ymd, please refer to the help for this funciton for details on appropriate formats.}

\item{offset}{time offset for CRU TS data}

\item{na.rm}{logical, whether to ignore NA's in averaging, default is FALSE (to be consistent with other R functions in other packages), but option TRUE should probably be used on most occasions}
}
\value{
a raster or polygon with the raw or spatially averaged anomalies
}
\description{
A function to extract anomalies from the Climatic Research Unit Time-Series dataset
}
\details{
Data can be obtained from \url{http://catalogue.ceda.ac.uk/uuid/ac4ecbd554d0dd52a9b575d9666dc42d}
}
