% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCMLE.R
\name{plotCMLE}
\alias{plotCMLE}
\title{Plot unconstrained and constrained proportional odds logit model}
\usage{
plotCMLE(
  mdcpResult = NULL,
  SignifLevel = 0.05,
  xposLegend = NULL,
  yposLegend = NULL,
  xcex.axis = 0.8,
  ycex.axis = 0.8,
  cexLegend = 1,
  methodName = "Not indicated"
)
}
\arguments{
\item{mdcpResult}{An object of class \code{list} storing the results of function \code{mdcp}, which fits both the unconstrained
and constrained proportional odds logit models.}

\item{SignifLevel}{Significance level to be used when constructing the confidence intervals for each parameter
of the unconstrained proportional odds logit model. Default value 0.05.}

\item{xposLegend}{Position of legend on the x-axis. If \code{xposLegend} or \code{yposLegend} are
not used, then the legend is located using \code{topleft} option.}

\item{yposLegend}{Position of legend on the y-axis. If \code{xposLegend} or \code{yposLegend} are
not used, then the legend is located using \code{topleft} option.}

\item{xcex.axis}{Size of \code{cex.axis} for the x-axis. Default value is 0.8.}

\item{ycex.axis}{Size of \code{cex.axis} for the y-axis. Default value is 0.8.}

\item{cexLegend}{Size of legend text to be assigned to \code{cex}. Default value is 1.}

\item{methodName}{Method name to be used in the main title of the plot.}
}
\value{
Plot.
}
\description{
Uses the results of function \code{mdcp} to produce a plot for the Maximum Likelihood Estimators of the parameters of both
the unconstrained and constrained proportional odds logit models (UMLE and CMLE
correspondingly). The UMLE includes confidence intervals. Parameter estimates of ordinal predictors
are graphically linked with segments.
}
\examples{
# Ordinal predictors: EduLevel, IncQuint, Health,
# Overcrowd, and NumChildren
mdcpExample <- mdcp(QoL ~ EduLevel + Age + IncQuint + Gender + Health, data = crovData,
CLS1 = 0.95, TLBS2 = 0.90, TLNS2 = 0.99, StepSizeCLS2 = 0.0002)
plotCMLE(mdcpResult=mdcpExample,SignifLevel=0.05,xposLegend=14, yposLegend=4.8,
cexLegend=0.8, method="MDCS3")
}
\seealso{
\code{\link[crov:monoTestBonf]{monoTestBonf}},
\code{\link[crov:monoTestConfReg]{monoTestConfReg}},
\code{\link[crov:monoTestBonf]{monoTestBonf}},
\code{\link[stats:constrOptim]{constrOptim}}.
}
