% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_target.R
\name{adjust_target}
\alias{adjust_target}
\title{Title Generate covariates' residuals}
\usage{
adjust_target(X, y1, y2 = NULL, cor_vars)
}
\arguments{
\item{X}{A dataset containing y1, y2, and covariates. The row name is the name of x,y and covariate}

\item{y1}{If cross lagged analysis is used between x and y, 'y1' is the name of x.}

\item{y2}{y2 can be NULL. If cross lagged analysis is used between x and y, 'y2' is the name of y. 'y1' and 'y2' come from the same time point.}

\item{cor_vars}{the name of covariate}
}
\value{
a list containing the covariate-adjusted value of y1 and y2 (If y2 is not NULL)
}
\description{
Title Generate covariates' residuals
}
\examples{
data(test_data1)
result <- adjust_target(X=test_data1,y1="ASI",y2=NULL,cor_vars=c("HDL_C","LDL_C"))
}
