% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.R
\name{build_instances}
\alias{build_instances}
\title{Internal: build per-method instance graph and fold geometry}
\usage{
build_instances(methods)
}
\arguments{
\item{methods}{A list of fully validated and normalized method
specifications, typically the output of
\code{\link{validate_batch}}.}
}
\value{
A list with components including (but not limited to):
\describe{
\item{\code{methods}}{The (possibly updated) methods list, with
\code{folds} harmonized.}
\item{\code{instances}}{Named list of instance nodes.}
\item{\code{roots}}{Per-method root instance keys
(corresponding to \code{"__TARGET__"}).}
\item{\code{topo}}{Instance keys in topological order.}
\item{\code{method_inst_keys}}{Per-method instance keys in
topological order.}
\item{\code{eval_width}}{Per-method evaluation window width.}
\item{\code{inst_offset}}{Per-instance training window offset
(in folds).}
\item{\code{K_required}}{Per-method minimal required number of
folds.}
\item{\code{K}}{Global number of folds used in the plan.}
\item{\code{child_maps}}{List of fit/predict child maps as
returned by \code{\link{build_child_maps}}.}
\item{\code{method_structs}}{Per-method set of structural
signatures used by that method.}
\item{\code{method_fold_allocation}}{Per-method
\code{fold_allocation} values.}
}
}
\description{
Given a list of validated methods (as returned by
\code{\link{validate_batch}}), constructs the global instance graph
used by the cross-fitting engine. Each nuisance (including the
synthetic \code{"__TARGET__"} node) is expanded into one or more
instances, depending on the fold allocation strategy.
}
\details{
This function:
\itemize{
\item builds a DAG of instances per method, starting from
\code{"__TARGET__"},
\item computes per-method evaluation width (\code{eval_width}),
\item assigns training window offsets (\code{inst_offset}) according
to \code{fold_allocation},
\item determines the minimal required number of folds
(\code{K_required}) per method and harmonizes a global
\code{K},
\item constructs child maps (via \code{\link{build_child_maps}}),
\item computes structural signatures and marks instances that are
worth caching.
}

The resulting "plan" object is consumed by the core engine
(\code{crossfit_multi()}).
}
\keyword{internal}
