% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_aws_batch.R
\name{crew_launcher_aws_batch}
\alias{crew_launcher_aws_batch}
\title{Create an AWS Batch launcher object.}
\usage{
crew_launcher_aws_batch(
  name = NULL,
  workers = 1L,
  seconds_interval = 0.5,
  seconds_timeout = 60,
  seconds_launch = 1800,
  seconds_idle = 300,
  seconds_wall = Inf,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL,
  crashes_error = NULL,
  tls = crew::crew_tls(mode = "automatic"),
  processes = NULL,
  r_arguments = c("--no-save", "--no-restore"),
  options_metrics = crew::crew_options_metrics(),
  options_aws_batch = crew.aws.batch::crew_options_aws_batch(),
  aws_batch_config = NULL,
  aws_batch_credentials = NULL,
  aws_batch_endpoint = NULL,
  aws_batch_region = NULL,
  aws_batch_job_definition = NULL,
  aws_batch_job_queue = NULL,
  aws_batch_share_identifier = NULL,
  aws_batch_scheduling_priority_override = NULL,
  aws_batch_parameters = NULL,
  aws_batch_container_overrides = NULL,
  aws_batch_node_overrides = NULL,
  aws_batch_retry_strategy = NULL,
  aws_batch_propagate_tags = NULL,
  aws_batch_timeout = NULL,
  aws_batch_tags = NULL,
  aws_batch_eks_properties_override = NULL
)
}
\arguments{
\item{name}{Character string, name of the launcher. If the name is
\code{NULL}, then a name is automatically generated when the launcher starts.}

\item{workers}{Maximum number of workers to run concurrently
when auto-scaling, excluding task retries and manual calls to \code{launch()}.
Special workers allocated for task retries
do not count towards this limit, so the number of workers running at a
given time may exceed this maximum.
A smaller number of workers may run if the number of executing tasks
is smaller than the supplied value of the \code{workers} argument.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete. In certain cases, exponential
backoff is used with this argument passed to \code{seconds_max}
in a \code{\link[crew:crew_throttle]{crew_throttle()}} object.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete,
such as checking \code{mirai::info()}.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::daemon()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::daemon()}.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. Also determines how often the controller auto-scales.
See the Auto-scaling section for details.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerstart} argument of \code{mirai::daemon()}.}

\item{reset_globals}{Deprecated on 2025-05-30 (\code{crew} version 1.1.2.9004).
Please use the \code{reset_globals} option of \code{\link[crew:crew_controller]{crew_controller()}}
instead.}

\item{reset_packages}{Deprecated on 2025-05-30 (\code{crew} version 1.1.2.9004).
Please use the \code{reset_packages} option of \code{\link[crew:crew_controller]{crew_controller()}}
instead.}

\item{reset_options}{Deprecated on 2025-05-30 (\code{crew} version 1.1.2.9004).
Please use the \code{reset_options} option of \code{\link[crew:crew_controller]{crew_controller()}}
instead.}

\item{garbage_collection}{Deprecated on 2025-05-30
(\code{crew} version 1.1.2.9004).
Please use the \code{garbage_collection} option of
\code{\link[crew:crew_controller]{crew_controller()}} instead.}

\item{crashes_error}{Deprecated on 2025-01-13 (\code{crew} version 0.10.2.9002).}

\item{tls}{A TLS configuration object from \code{\link[crew:crew_tls]{crew_tls()}}.}

\item{processes}{Deprecated on 2025-08-27 (\code{crew} version 1.2.1.9009).}

\item{r_arguments}{Optional character vector of command line arguments
to pass to \code{Rscript} (non-Windows) or \code{Rscript.exe} (Windows)
when starting a worker. Example:
\code{r_arguments = c("--vanilla", "--max-connections=32")}.}

\item{options_metrics}{Either \code{NULL} to opt out of resource metric logging
for workers, or an object from \code{\link[crew:crew_options_metrics]{crew_options_metrics()}} to enable
and configure resource metric logging for workers.
For resource logging to run,
the \code{autometric} R package version 0.1.0 or higher
must be installed.}

\item{options_aws_batch}{List of options from \code{\link[=crew_options_aws_batch]{crew_options_aws_batch()}}.
The job definition and job queue must be specified in
\code{\link[=crew_options_aws_batch]{crew_options_aws_batch()}}. \code{\link[=crew_options_aws_batch]{crew_options_aws_batch()}} also allows
you to request vCPUs, GPUs, and memory for the jobs.}

\item{aws_batch_config}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_credentials}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_endpoint}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_region}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_job_definition}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_job_queue}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_share_identifier}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_scheduling_priority_override}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_parameters}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_container_overrides}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_node_overrides}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_retry_strategy}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_propagate_tags}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_timeout}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_tags}{Deprecated.
Use \code{options_aws_batch} instead.}

\item{aws_batch_eks_properties_override}{Deprecated.
Use \code{options_aws_batch} instead.}
}
\value{
An \code{R6} AWS Batch launcher object.
}
\description{
Create an \code{R6} AWS Batch launcher object.
}
\section{IAM policies}{

In order for the AWS Batch \code{crew} plugin to function properly, your IAM
policy needs permission to perform the \code{SubmitJob} and \code{TerminateJob}
AWS Batch API calls. For more information on AWS policies and permissions,
please visit
\url{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}.
}

\section{AWS arguments}{

The AWS Batch controller and launcher accept many arguments
which start with \code{"aws_batch_"}. These arguments are AWS-Batch-specific
parameters forwarded directly to the \code{submit_job()} method for
the Batch client in the \code{paws.compute} R package

For a full description
of each argument, including its meaning and format, please visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/}. The upstream API
documentation is at
\url{https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html}
and the analogous CLI documentation is at
\url{https://docs.aws.amazon.com/cli/latest/reference/batch/submit-job.html}.

The actual argument names may vary slightly, depending
on which : for example, the \code{aws_batch_job_definition} argument of
the \code{crew} AWS Batch launcher/controller corresponds to the
\code{jobDefinition} argument of the web API and
\code{paws.compute::batch()$submit_job()}, and both correspond to the
\code{--job-definition} argument of the CLI.
}

\section{Verbosity}{

Control verbosity with the \code{paws.log_level} global option in R.
Set to 0 for minimum verbosity and 3 for maximum verbosity.
}

\seealso{
Other plugin_aws_batch: 
\code{\link{crew_class_launcher_aws_batch}},
\code{\link{crew_controller_aws_batch}()}
}
\concept{plugin_aws_batch}
