% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crwPredict.R
\name{crwPredict}
\alias{crwPredict}
\title{Predict animal locations and velocities using a fitted CTCRW model and
calculate measurement error fit statistics}
\usage{
crwPredict(object.crwFit, predTime = NULL, return.type = "minimal", ...)
}
\arguments{
\item{object.crwFit}{A model object from \code{\link{crwMLE}}.}

\item{predTime}{vector of desired prediction times (numeric or POSIXct). Alternatively, a character vector specifying a time interval (see Details).}

\item{return.type}{character. Should be one of \code{"minimal","flat","list"} (see Details).}

\item{...}{Additional arguments for testing new features}
}
\value{
There are three possible return types specified with `return.type`:

\item{minimal}{a data.frame with a minimal set of columns: 
\code{date_time,mu.x,mu.y,se.mu.x,se.mu.y}}

\item{flat}{a data set is returned with the
columns of the original data plus the state estimates, standard errors (se),
and speed estimates}

\item{list}{List with the following elements:}

\item{originalData}{A data.frame with `data` merged with
`predTime`.}

\item{alpha.hat}{Predicted state}

\item{Var.hat}{array where \code{Var.hat[,,i]} is the prediction
covariance matrix for \code{alpha.hat[,i]}.}
}
\description{
The \code{crwMEfilter} function uses a fitted model object from
\code{crwMLE} to predict animal locations (with estimated uncertainty) at
times in the original data set and supplemented by times in \code{predTime}.
If \code{speedEst} is set to \code{TRUE}, then animal log-speed is also
estimated. In addition, the measurement error shock detection filter of de
Jong and Penzer (1998) is also calculated to provide a measure for outlier
detection.
}
\details{
The requirements for \code{data} are the same as those for fitting the model
in \code{\link{crwMLE}}.

\code{predTime} can be either passed as a separate vector of POSIXct or 
numeric values for all prediction times expected in the returned object. 
Note, previous versions of \code{crwPredict} would return both times 
specified via \code{predTime} as well as each original observed time. This is
 no longer the default (see \code{return.type}). If the original data were 
 provided as a POSIXct type, then \code{crwPredict} can derive a sequence of 
 regularly spaced prediction times from the original data. This is specified 
 by providing a character string that corresponds to the \code{by} argument 
 of the \code{seq.POSIXt} function (e.g. '1 hour', '30 mins'). 
 \code{crwPredict} will round the first observed time up to the nearest unit 
 (e.g. '1 hour' will round up to the nearest hour, '30 mins' will round up to 
 the nearest minute) and start the sequence from there. The last observation 
 time is truncated down to the nearest unit to specify the end time.
}
\references{
de Jong, P. and Penzer, J. (1998) Diagnosing shocks in time
series. Journal of the American Statistical Association 93:796-806.
}
\author{
Devin S. Johnson
}
